<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Task extends Eloquent {

	protected $table = 'tasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->belongsTo('App\Models\Status');
	}

	public function files()
	{
		return $this->morphMany('App\Models\File', 'model');
	}

	public function prority()
	{
		return $this->hasOne('App\Models\Priority');
	}

}