<?php

namespace App\Models;

class Trip extends Eloquent {

	protected $table = 'trips';
	public $timestamps = true;
	protected $fillable = array('departure', 'trip_number');

	public function ticketAvailabilities()
	{
		return $this->hasMany('App\Models\TicketAvailability');
	}

	public function vessel()
	{
		return $this->belongsTo('App\Models\Vessel');
	}

	public function route()
	{
		return $this->belongsTo('App\Models\Route');
	}

}