<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Orcamento extends Model 
{

    protected $table = 'orcamentos';
    public $timestamps = true;

    public function solicitacoes()
    {
        return $this->belongsToMany('Solicitacao');
    }

    public function produtos()
    {
        return $this->hasOne('Produto');
    }

    public function usuarios()
    {
        return $this->belongsTo('Usuario');
    }

    public function fornecedores()
    {
        return $this->hasOne('Fornecedor');
    }

}