<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountTable extends Migration {

	public function up()
	{
		Schema::create('bank_account', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('person_id')->unsigned();
			$table->integer('sort_code');
			$table->integer('account_number');
			$table->string('iban', 255);
			$table->string('bic', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
		});
	}

	public function down()
	{
		Schema::drop('bank_account');
	}
}