<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotesTable extends Migration {

	public function up()
	{
		Schema::create('quotes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->date('date_expires');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('quotes');
	}
}