<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSicknessTable extends Migration {

	public function up()
	{
		Schema::create('sickness', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('appointment_id')->unsigned();
			$table->integer('approver_id')->unsigned();
			$table->datetimeTz('datetime_approved');
			$table->date('date_from');
			$table->date('date_to')->nullable();
			$table->integer('category_sickness_type_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sickness');
	}
}