<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->text('full_markdown');
			$table->decimal('days_holiday', 8,2);
			$table->boolean('bank_holidays_mandatory')->nullable();
			$table->boolean('is_zero_hours');
			$table->boolean('is_fixed_term');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}