<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Currency extends Eloquent {

	protected $table = 'currencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function listings()
	{
		return $this->hasMany('App\Models\Listing\Listing', 'currency_id');
	}

	public function lines()
	{
		return $this->hasMany('App\Models\Finance\Line', 'currency_id');
	}

	public function invoices()
	{
		return $this->hasMany('App\Models\Finance\Invoice', 'invoice_id');
	}

	public function settlements()
	{
		return $this->hasMany('App\Models\Finance\Settlement', 'currency_id');
	}

}