<?php

namespace App\Models\Person;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Person extends Eloquent {

	protected $table = 'person';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products_identifiers_types()
	{
		return $this->hasMany('App\Models\Product\ProductIdentifierType', 'person_id');
	}

	public function bank_accounts()
	{
		return $this->hasMany('App\Models\Person\BankAccount', 'person_id');
	}

	public function appointments()
	{
		return $this->hasMany('App\Models\HR\Appointment', 'appointment_id');
	}

}