<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductIdentifierType extends Eloquent {

	protected $table = 'products_identifiers_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products_identifiers()
	{
		return $this->hasMany('App\Models\Product\ProductIdentifier', 'product_identifier_type_id');
	}

	public function person()
	{
		return $this->belongsTo('App\Models\Person\Person', 'person_id');
	}

}