<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductVariation extends Eloquent {

	protected $table = 'products_variations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function abstracts()
	{
		return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
	}

	public function products_instances()
	{
		return $this->hasMany('App\Models\Product\ProductInstance', 'product_instance_id');
	}

	public function product()
	{
		return $this->belongsTo('App\Models\Product\Product', 'product_id');
	}

}