<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quote extends Eloquent {

	protected $table = 'quotes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function lines()
	{
		return $this->morphMany('App\Models\Finance\Line', 'lineable');
	}

	public function customer()
	{
		return $this->belongsTo('App\Models\Person\Person', 'customer_id');
	}

	public function supplier()
	{
		return $this->belongsTo('App\Models\Person\Person', 'supplier_id');
	}

}