<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Settlement extends Eloquent {

	protected $table = 'settlement';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function bank_account_from()
	{
		return $this->belongsTo('App\Models\Person\BankAccount', 'bank_account_from_id');
	}

	public function bank_account_to()
	{
		return $this->belongsTo('App\Models\Person\BankAccount', 'bank_account_to_id');
	}

	public function reconciliations()
	{
		return $this->hasMany('App\Models\Finance\InvoiceReconciliation', 'settlement_id');
	}

}