<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->integer('id')->unique()->unsigned();
			$table->string('url', 1000)->nullable();
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('visits')->nullable();
			$table->integer('page_rank')->nullable();
			$table->integer('alexa_rank')->nullable();
			$table->integer('category')->nullable();
			$table->float('average_facebook_shares', 40,20)->nullable();
			$table->integer('influencer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}