<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfluencerMatchesTable extends Migration {

	public function up()
	{
		Schema::create('influencer_matches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('influence_score')->nullable();
			$table->float('relevancy_score', 40,20)->nullable();
			$table->integer('search_terms_id')->unsigned();
			$table->integer('influencer_id')->unsigned();
			$table->boolean('active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('influencer_matches');
	}
}