<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sale extends Eloquent {

	protected $table = 'sales';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function book()
	{
		return $this->hasOne('Book');
	}

	public function academic_year()
	{
		return $this->hasOne('AcademicYear');
	}

}