<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidsTable extends Migration {

	public function up()
	{
		Schema::create('bids', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('project_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('budget');
			$table->text('message');
			$table->integer('duration');
		});
	}

	public function down()
	{
		Schema::drop('bids');
	}
}