<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserReviewTable extends Migration {

	public function up()
	{
		Schema::create('user_review', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('value');
			$table->string('description')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('tutor_id')->unsigned();
			$table->string('reviewer')->default('user');
		});
	}

	public function down()
	{
		Schema::drop('user_review');
	}
}