<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'question';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'image', 'published');

	public function Answer()
	{
		return $this->hasMany('Answer');
	}

	public function Quiz()
	{
		return $this->belongsTo('Quiz');
	}

}