<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('offer_id')->nullable();
			$table->longText('name');
			$table->string('item_code', 50)->nullable();
			$table->string('sku', 50);
			$table->string('banner_image', 255);
			$table->string('thum_panel_image', 255);
			$table->string('hover_image', 255);
			$table->longText('description');
			$table->string('add_image', 255)->nullable();
			$table->json('related_product');
			$table->double('price');
			$table->double('production_cost');
			$table->bigInteger('rate_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}