<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffsTable extends Migration {

	public function up()
	{
		Schema::create('staffs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('password', 255);
			$table->string('phone', 255);
			$table->string('image', 255);
			$table->timestamp('last_login')->nullable();
			$table->enum('staff_type', array('admin', 'employee'));
			$table->integer('created_by_id')->unsigned();
			$table->string('email', 255);
		});
	}

	public function down()
	{
		Schema::drop('staffs');
	}
}