<?php

namespace App\Models;

class Color extends Eloquent {

	protected $table = 'colors';
	public $timestamps = true;
	protected $fillable = array('code', 'name', 'product_id');

	public function medias()
	{
		return $this->morphMany('App\Models\Media', 'mediaable');
	}

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

}