<?php

namespace App\Models;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;
	protected $fillable = array('title', 'body', 'comment_id', 'product_id');

	public function childs_comments()
	{
		return $this->belongsTo('App\Models\Comment', 'comment_id');
	}

	public function parents_comments()
	{
		return $this->belongsTo('App\Models\Comment', 'comment_id');
	}

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

}