<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->text('question');
			$table->text('reponse');
			$table->text('observations')->nullable();
			$table->datetime('date_publication')->nullable();
			$table->datetime('date_derniere_modification')->nullable();
			$table->string('etat', 50);
			$table->boolean('est_publie')->default(0);
			$table->bigInteger('add_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}