<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTextesTable extends Migration {

	public function up()
	{
		Schema::create('textes', function(Blueprint $table) {
			$table->increments('id');
			$table->text('nom');
			$table->text('description');
			$table->text('url')->nullable();
			$table->string('fichier')->nullable();
			$table->text('observations')->nullable();
			$table->integer('type_texte_id')->unsigned();
			$table->string('etat', 30);
			$table->boolean('est_publie')->default(0);
			$table->datetime('date_publication')->nullable();
			$table->datetime('date_derniere_modification')->nullable();
			$table->bigInteger('add_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('textes');
	}
}