<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEspaceSenegalServicesTable extends Migration {

	public function up()
	{
		Schema::create('espace_senegal_services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('libelle');
			$table->text('description')->nullable();
			$table->string('adresse')->nullable();
			$table->string('email')->nullable();
			$table->string('telephone_principal', 30)->nullable();
			$table->string('telephone_secondaire', 30)->nullable();
			$table->string('site_web')->nullable();
			$table->string('boite_postale', 30)->nullable();
			$table->string('code_collectivite', 30)->nullable();
			$table->string('lattiude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('altitude')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('espace_senegal_services');
	}
}