<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('service_procedures', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('service_procedures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('service_procedures', function(Blueprint $table) {
			$table->dropForeign('service_procedures_service_id_foreign');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_specialty_id_foreign');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->dropForeign('specialty_doctor_specialty_id_foreign');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->dropForeign('specialty_doctor_doctor_id_foreign');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->dropForeign('page_sections_page_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_doctor_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_specialty_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_procedure_id_foreign');
		});
	}
}