<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 255);
			$table->string('phone', 255)->nullable();
			$table->string('image', 255)->nullable();
			$table->string('position', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->bigInteger('specialty_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}