<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDirectoriesTable extends Migration {

	public function up()
	{
		Schema::create('directories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('phone_number', 15);
			$table->string('logo', 191);
			$table->boolean('is_active')->default(1);
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('entity_name', 191)->nullable();
			$table->string('representative_name', 191)->nullable();
			$table->string('email', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('directories');
	}
}