<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->string('model_type', 191);
			$table->integer('model_id')->unsigned();
			$table->string('path', 191);
			$table->string('tag', 191)->nullable();
			$table->string('file_name', 191)->nullable();
			$table->string('notes', 191)->nullable();
			$table->smallInteger('order')->default('0');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}