<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRemindersTable extends Migration {

	public function up()
	{
		Schema::create('reminders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('code')->nullable();
			$table->tinyInteger('completed');
			$table->timestamp('completed_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reminders');
	}
}