<?php

namespace Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Author()
    {
        return $this->belongsTo('User\User', 'user_id');
    }

    public function metaData()
    {
        return $this->morphMany('Meta\Meta', 'meta_model');
    }

}