<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function permisions()
	{
		return $this->belongsToMany('Role');
	}

	public function admins()
	{
		return $this->morphedByMany('Admin');
	}

	public function users()
	{
		return $this->morphedByMany('User');
	}

}