<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('payment_method', array('cash', 'cheque'));
			$table->string('cheq_no')->default('255');
			$table->date('cheq_date');
			$table->text('payee_bank');
			$table->longText('description');
			$table->double('amount');
			$table->longText('reason')->nullable();
			$table->enum('status', array('hold', 'clear', 'bounce', 'replace'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}