<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuildingsTable extends Migration {

	public function up()
	{
		Schema::create('buildings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('type_id');
			$table->string('lat', 255);
			$table->string('lng', 255);
			$table->string('address', 255);
			$table->enum('use', array('living', 'commercial'));
			$table->text('cancel_reason');
			$table->string('ref_code', 255);
			$table->double('age', 255)->default('0,0');
			$table->double('area', 255)->default('0,0');
			$table->double('ratio', 255)->default('0,0');
			$table->integer('users_count');
			$table->integer('units_count');
			$table->string('contract', 255);
			$table->string('instrument', 255);
			$table->string('construction_completion_certificate', 255);
			$table->string('civil_defense_certificate', 255);
			$table->enum('status', array('pending', 'accepted', 'refused', 'finished', 'canceled'));
			$table->integer('owner_id')->unsigned()->nullable();
			$table->integer('manager_id')->unsigned()->nullable();
			$table->boolean('seen');
		});
	}

	public function down()
	{
		Schema::drop('buildings');
	}
}