<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitlementsTable extends Migration {

	public function up()
	{
		Schema::create('entitlements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('building_id')->unsigned()->nullable();
			$table->integer('manager_id')->unsigned()->nullable();
			$table->date('start');
			$table->date('end');
			$table->date('day_date');
			$table->double('price', 100)->default('0,0');
			$table->enum('status', array('true', 'false'));
		});
	}

	public function down()
	{
		Schema::drop('entitlements');
	}
}