<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkersTable extends Migration {

	public function up()
	{
		Schema::create('workers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('maintenance_type_id')->unsigned()->nullable();
			$table->string('phone', 255);
			$table->string('country_key', 50);
			$table->double('rate', 100);
			$table->integer('manager_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('workers');
	}
}