<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('plan_id')->unsigned()->nullable();
			$table->integer('manager_id')->unsigned()->nullable();
			$table->double('price');
			$table->integer('duration');
			$table->date('start_at');
			$table->date('end_at');
			$table->enum('payment_type', array('wallet', 'online'));
			$table->boolean('payment_status');
			$table->boolean('unsupscribe');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}