<?php

namespace CityTransaltion;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CityTransaltion extends Model 
{

    protected $table = 'cities_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}