<?php

namespace CountryTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CountryTranslation extends Model 
{

    protected $table = 'countries_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}