<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmitentsTable extends Migration {

	public function up()
	{
		Schema::create('emitents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('company_name');
			$table->string('pib')->nullable();
			$table->string('description')->nullable();
			$table->string('price_list')->nullable();
			$table->string('address')->nullable();
			$table->string('phone_number')->nullable();
			$table->string('stars')->nullable();
			$table->string('primary_color')->nullable();
			$table->string('secondary_color')->nullable();
			$table->string('logo')->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('website')->nullable();
			$table->string('contact_person')->nullable();
			$table->string('pdv')->nullable();
			$table->double('emission_limit')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('emitents');
	}
}