<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVoucherTypesTable extends Migration {

	public function up()
	{
		Schema::create('voucher_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->integer('visibility_id')->unsigned();
			$table->datetime('deadline_from');
			$table->datetime('deadline_to');
			$table->double('emission_limit');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('voucher_types');
	}
}