<?php

namespace EmitentContent;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmitentContent extends Model 
{

    protected $table = 'emitent_content';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function images()
    {
        return $this->morphMany('Image', 'imageable');
    }

    public function emitent()
    {
        return $this->belongsTo('Emitent', 'emitent_id');
    }

}