<?php

namespace Voucher;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Voucher extends Model 
{

    protected $table = 'vouchers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->belongsTo('VoucherStatus', 'status_id');
    }

    public function emitent()
    {
        return $this->belongsTo('User', 'emitent_id');
    }

    public function type()
    {
        return $this->belongsTo('UserVoucherType', 'user_voucher_type_id');
    }

}