<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7ArtistWorkTable extends Migration {

	public function up()
	{
		Schema::create('nh7_artist_work', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('artist_id')->unsigned();
			$table->text('url');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('sequence_no')->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_artist_work');
	}
}