<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7CityTable extends Migration {

	public function up()
	{
		Schema::create('nh7_city', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->string('title')->nullable();
			$table->string('type');
			$table->string('slug');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_city');
	}
}