<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('wallet_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('old_balance', 20,2)->default('0');
			$table->decimal('balance', 20,2);
			$table->decimal('amount', 20,2);
			$table->integer('wallet_id');
			$table->tinyInteger('operation');
			$table->text('details_ar')->nullable();
			$table->text('details_en')->nullable();
			$table->integer('user_id');
			$table->integer('investor_transaction_id');
		});
	}

	public function down()
	{
		Schema::drop('wallet_transactions');
	}
}