<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletsTable extends Migration {

	public function up()
	{
		Schema::create('wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_ar');
			$table->string('name_en');
			$table->decimal('balance', 20,2)->default('0');
			$table->decimal('initial_balance', 20,2)->default('0');
			$table->integer('iban_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('wallets');
	}
}