<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password');
    protected $hidden = array('password', 'remember_token');

    public function scripts()
    {
        return $this->hasMany('Script', 'owner');
    }

    public function blocks()
    {
        return $this->hasMany('Block', 'owner');
    }

    public function comments()
    {
        return $this->hasOne('Kommentar', 'owner');
    }

}