<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDataTagsTable extends Migration {

	public function up()
	{
		Schema::create('data_tags', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('pid')->unsigned()->index();
			$table->bigInteger('tid')->unsigned()->index();
			$table->string('value');
			$table->tinyInteger('type')->unsigned()->index();
			$table->timestamp('date')->index();
		});
	}

	public function down()
	{
		Schema::drop('data_tags');
	}
}